
import SwiftUI

struct ContentView: View {
   var body: some View {
      VStack {
         Text("Hello, world!")
            .padding()
         Button("Run Task") {
            let myTask = Task {
               let imageName = await loadImage(name: "My Image")
               print(imageName)
            }
            Timer.scheduledTimer(withTimeInterval: 2.0, repeats: false) { timer in
               myTask.cancel()
            }
         }
      }
   }
   func loadImage(name: String) async -> String {
      try? await Task.sleep(for: .seconds(5))
      if Task.isCancelled {
         return "Task Cancelled"
      }
      return "Name: \(name)"
   }
}

#Preview {
    ContentView()
}
